<!DOCTYPE html>
<html lang="en" class="dark">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Meet - Dashboard</title>
  <script src="../tailwind.js"></script>
 <script>
       // Check authentication
    fetch('../../server/auth/check_session.php', {
      method: 'GET',
      headers: { 'Content-Type': 'application/json' }
    })
      .then(response => response.json())
      .then(data => {
        if (!data.success) {
          window.location.href = '../login.php?error=Please log in';
          return;
        }
        document.getElementById('username-display').textContent = data.user.username;
        document.getElementById('avatar-display').src = data.user.avatar;
        document.getElementById('profile-username').textContent = data.user.username;
        document.getElementById('profile-email').textContent = data.user.email;
      })
      .catch(error => {
        console.error('Error:', error);
        window.location.href = '../login.php?error=Session error';
      });
 </script>
  <script>
    tailwind.config = { darkMode: 'class' }
    if (localStorage.theme === 'dark' ||
      (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)
    ) {
      document.documentElement.classList.add('dark')
    } else {
      document.documentElement.classList.remove('dark')
    }
  </script>
  <style>
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(20px); }
      to { opacity: 1; transform: translateY(0); }
    }
    .animate-fadeIn { animation: fadeIn 0.6s ease-out forwards; }
    .delay-100 { animation-delay: 0.1s; }
    .delay-200 { animation-delay: 0.2s; }

    @keyframes pulse {
      0%, 100% { opacity: 0.3; }
      50% { opacity: 0.6; }
    }
    .grid-dot { animation: pulse 3s infinite ease-in-out; }
  </style>
</head>
<body class="bg-white dark:bg-gray-900 min-h-screen transition-colors duration-300">
<?php include 'nav.php'; ?>
<!-- JavaScript for Dropdown Toggle -->
<script>
  const avatarBtn = document.getElementById('avatar-btn');
  const userMenu = document.getElementById('user-menu');

  avatarBtn.addEventListener('click', () => {
    const isHidden = userMenu.classList.contains('hidden');
    userMenu.classList.toggle('hidden', !isHidden);
    userMenu.classList.toggle('scale-95', !isHidden);
    userMenu.classList.toggle('opacity-0', !isHidden);
    userMenu.classList.toggle('scale-100', isHidden);
    userMenu.classList.toggle('opacity-100', isHidden);
  });

  // Close dropdown when clicking outside
  document.addEventListener('click', (e) => {
    if (!avatarBtn.contains(e.target) && !userMenu.contains(e.target)) {
      userMenu.classList.add('hidden', 'scale-95', 'opacity-0');
      userMenu.classList.remove('scale-100', 'opacity-100');
    }
  });
</script>
  <!-- Main Content -->
  <div class="max-w-7xl mx-auto p-6 grid grid-cols-1 md:grid-cols-3 gap-6 animate-fadeIn">
    <!-- Start/Join Call Section -->
    <div class="md:col-span-2 bg-white/90 dark:bg-gray-900/90 backdrop-blur-xl rounded-2xl shadow-lg p-6">
      <h2 class="text-2xl font-bold text-black dark:text-white mb-4">Video Calls</h2>
      <div class="space-y-4">
        <div>
          <button id="start-call-btn" class="w-full px-4 py-3 bg-black dark:bg-white text-white dark:text-black rounded-lg font-medium hover:bg-gray-800 dark:hover:bg-gray-200 transition-all duration-300 hover:scale-105">Get New Call link</button>
        </div>
        <div>
          <label for="room-id" class="block text-sm font-medium text-black dark:text-white">Join Call by Room ID</label>
          <div class="flex space-x-2">
            <input type="text" id="room-id" placeholder="Enter Room ID" class="mt-1 w-full px-4 py-3 bg-gray-100 dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-lg focus:outline-none focus:ring-2 focus:ring-black dark:focus:ring-white text-black dark:text-white transition">
            <button id="join-call-btn" class="px-4 py-3 bg-black dark:bg-white text-white dark:text-black rounded-lg font-medium hover:bg-gray-800 dark:hover:bg-gray-200 transition-all duration-300 hover:scale-105">Join</button>
          </div>
        </div>
        <p id="call-error" class="text-red-500 text-sm hidden"></p>
      </div>
    </div>

    <!-- Profile Section -->
    <div class="bg-white/90 dark:bg-gray-900/90 backdrop-blur-xl rounded-2xl shadow-lg p-6">
      <h2 class="text-2xl font-bold text-black dark:text-white mb-4">Profile</h2>
      <p class="text-gray-600 dark:text-gray-400"><strong>Username:</strong> <span id="profile-username"></span></p>
      <p class="text-gray-600 dark:text-gray-400"><strong>Email:</strong> <span id="profile-email"></span></p>
      <button id="edit-profile-btn" class="mt-4 w-full px-4 py-3 bg-black dark:bg-white text-white dark:text-black rounded-lg font-medium hover:bg-gray-800 dark:hover:bg-gray-200 transition-all duration-300 hover:scale-105">Edit Profile</button>
    </div>

    <!-- Call History Section -->
    <div class="md:col-span-3 bg-white/90 dark:bg-gray-900/90 backdrop-blur-xl rounded-2xl shadow-lg p-6">
      <h2 class="text-2xl font-bold text-black dark:text-white mb-4">Call History</h2>
      <div id="call-history" class="space-y-4"></div>
      <div class="flex justify-end mb-4">
  <a href="call-history.php" 
     class="px-6 py-2 bg-blue-500 hover:bg-blue-600 text-white dark:text-gray-900 rounded-xl shadow-md transition-colors duration-200 font-semibold">
    View All Call History
  </a>
</div>  
    </div>
  </div>
  <script>
  function getQueryParam(name) {
    const urlParams = new URLSearchParams(window.location.search);
    return urlParams.get(name);
  }

  // Check query string on page load
  const successMsg = getQueryParam('success');
  const errorMsg = getQueryParam('error');
const WarnMsg = getQueryParam('warning');
  if (successMsg) {
    Swal.fire({
      icon: 'success',
      toast: true,
        position: 'top-end',
      text: successMsg,
      timer: 2000,
      showConfirmButton: false
    });
  } else if (errorMsg) {
    Swal.fire({
      icon: 'error',
      toast: true,
        position: 'top-end',
      text: errorMsg,
      timer: 2000,
      showConfirmButton: false
    });
  }
  else if (WarnMsg) {
    Swal.fire({
      icon: 'warning',
      toast: true,
        position: 'top-end',
      text: WarnMsg,
      timer: 2000,
      showConfirmButton: false
    });
  }
</script>
  <div id="historycall"></div>
<?php include 'script.php' ?>
</body>
</html>