<footer class="relative bg-white dark:bg-black pt-16 pb-8 mt-20 overflow-hidden">
  <!-- Decorative Blobs -->
  <div class="absolute top-0 right-0 w-72 h-72 bg-white/10 dark:bg-white/5 rounded-full blur-3xl animate-pulse"></div>
  <div class="absolute bottom-0 left-0 w-96 h-96 bg-white/10 dark:bg-white/5 rounded-full blur-3xl animate-ping"></div>

  <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <!-- Top Grid -->
    <div class="grid gap-12 lg:grid-cols-4 md:grid-cols-2 sm:grid-cols-1">
      <!-- Brand -->
      <div>
        <div class="flex items-center space-x-2">
          <svg class="w-10 h-10 text-black dark:text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M4 6h8a2 2 0 012 2v8a2 2 0 01-2 2H4a2 2 0 01-2-2V8a2 2 0 012-2z" />
          </svg>
          <span class="text-2xl font-bold text-black dark:text-white">Meet</span>
        </div>
        <p class="mt-4 text-black/70 dark:text-white/70 max-w-xs">
          Redefining how people connect worldwide with crystal-clear video and collaboration tools.
        </p>
      </div>

      <!-- Links -->
      <div>
        <h4 class="text-lg font-semibold text-black dark:text-white mb-4">Company</h4>
        <ul class="space-y-3 text-black/70 dark:text-white/70">
          <li><a href="#about" class="hover:text-black/90 dark:hover:text-white/90 transition">About Us</a></li>
          <li><a href="#careers" class="hover:text-black/90 dark:hover:text-white/90 transition">Careers</a></li>
          <li><a href="#blog" class="hover:text-black/90 dark:hover:text-white/90 transition">Blog</a></li>
          <li><a href="#press" class="hover:text-black/90 dark:hover:text-white/90 transition">Press</a></li>
        </ul>
      </div>

      <!-- Support -->
      <div>
        <h4 class="text-lg font-semibold text-black dark:text-white mb-4">Support</h4>
        <ul class="space-y-3 text-black/70 dark:text-white/70">
          <li><a href="#help" class="hover:text-black/90 dark:hover:text-white/90 transition">Help Center</a></li>
          <li><a href="#faq" class="hover:text-black/90 dark:hover:text-white/90 transition">FAQs</a></li>
          <li><a href="#contact" class="hover:text-black/90 dark:hover:text-white/90 transition">Contact Us</a></li>
          <li><a href="#status" class="hover:text-black/90 dark:hover:text-white/90 transition">System Status</a></li>
        </ul>
      </div>

      <!-- Newsletter -->
      <div>
        <h4 class="text-lg font-semibold text-black dark:text-white mb-4">Subscribe</h4>
        <p class="text-black/70 dark:text-white/70 mb-4">Get the latest news & updates.</p>
        <form class="flex items-center space-x-2">
          <input
            type="email"
            name="email"
            placeholder="Your email"
            class="flex-1 px-4 py-2 rounded-full bg-white/80 dark:bg-black/80 text-black dark:text-white placeholder-black/50 dark:placeholder-white/50 focus:outline-none focus:ring-2 focus:ring-black dark:focus:ring-white transition"
          />
          <button
            type="submit"
            class="px-4 py-2 rounded-full bg-black dark:bg-white text-white dark:text-black font-semibold shadow hover:scale-105 transition"
          >
            Join
          </button>
        </form>
      </div>
    </div>

    <!-- Divider -->
    <div class="border-t border-white/30 dark:border-white/10 my-8"></div>

    <!-- Bottom Flex -->
    <div class="flex flex-col md:flex-row items-center justify-between text-black/70 dark:text-white/70 space-y-4 md:space-y-0">
      <p>&copy; 2025 Meet. All rights reserved.</p>
      <div class="flex space-x-4">
        <a href="#" class="hover:text-black/90 dark:hover:text-white/90 transition">
          <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
            <path d="M22.54 6.42c-.2-.74-.78-1.32-1.52-1.52C19.45 4.5 12 4.5 12 4.5s-7.45 0-9.02.4c-.74.2-1.32.78-1.52 1.52C1 8 1 12 1 12s0 4 0.46 5.58c.2.74.78 1.32 1.52 1.52C4.55 19.5 12 19.5 12 19.5s7.45 0 9.02-.4c.74-.2 1.32-.78 1.52-1.52C23 16 23 12 23 12s0-4-.46-5.58z"/>
            <path fill="#fff" d="M9.75 15.02L15.5 12l-5.75-3.02z"/>
          </svg>
        </a>
        <a href="#" class="hover:text-black/90 dark:hover:text-white/90 transition">
          <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
            <path d="M23 3a10.9 10.9 0 01-3.14 1.53A4.48 4.48 0 0022.4.36a9.14 9.14 0 01-2.9 1.11A4.52 4.52 0 0016.11 0c-2.53 0-4.59 2.06-4.59 4.59 0 .36.04.72.12 1.06A12.86 12.86 0 013 1.62a4.58 4.58 0 00-.62 2.31 4.59 4.59 0 002.04 3.82 4.5 4.5 0 01-2.08-.57v.06c0 2.21 1.57 4.06 3.65 4.48a4.52 4.52 0 01-2.07.08 4.6 4.6 0 004.29 3.19A9.05 9.05 0 012 19.54a12.84 12.84 0 006.95 2.04c8.34 0 12.9-6.9 12.9-12.9 0-.2-.01-.41-.02-.61A9.18 9.18 0 0023 3z"/>
          </svg>
        </a>
        <a href="#" class="hover:text-black/90 dark:hover:text-white/90 transition">
          <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
            <path d="M19 0h-14c-2.761 0-5 2.239-5 5v14c0 2.761 2.239 5 5 5h7v-9h-3v-3h3v-2.271c0-3.007 1.792-4.729 4.533-4.729 1.312 0 2.686.235 2.686.235v3h-1.513c-1.494 0-1.987.926-1.987 1.874v2.891h3.377l-.54 3h-2.837v9h4c2.761 0 5-2.239 5-5v-14c0-2.761-2.239-5-5-5z"/>
          </svg>
        </a>
      </div>
    </div>
  </div>
</footer>

<!-- Scroll to Top Button -->
<button
  id="scrollToTopBtn"
  class="fixed bottom-6 right-6 p-3 rounded-full bg-black dark:bg-white text-white dark:text-black shadow-xl hover:scale-110 hover:shadow-2xl transition transform opacity-0 pointer-events-none z-50"
>
  <!-- Icon -->
  <svg class="w-6 h-6" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
    <path stroke-linecap="round" stroke-linejoin="round" d="M5 15l7-7 7 7" />
  </svg>
</button>

<script>
  const scrollToTopBtn = document.getElementById('scrollToTopBtn');

  window.addEventListener('scroll', () => {
    if (window.scrollY > 200) {
      scrollToTopBtn.classList.remove('opacity-0', 'pointer-events-none');
      scrollToTopBtn.classList.add('opacity-100');
    } else {
      scrollToTopBtn.classList.add('opacity-0', 'pointer-events-none');
      scrollToTopBtn.classList.remove('opacity-100');
    }
  });

  scrollToTopBtn.addEventListener('click', () => {
    window.scrollTo({ top: 0, behavior: 'smooth' });
  });
</script>