<?php
// send_invite.php
header('Content-Type: application/json');

try {
    $input = json_decode(file_get_contents('php://input'), true);

    if (!isset($input['email']) || !isset($input['callLink'])) {
        echo json_encode(['success' => false, 'message' => 'Missing parameters']);
        exit;
    }

    $email = filter_var($input['email'], FILTER_SANITIZE_EMAIL);
    $callLink = filter_var($input['callLink'], FILTER_SANITIZE_URL);

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo json_encode(['success' => false, 'message' => 'Invalid email']);
        exit;
    }

    // Resend API
    $apiKey = "re_12NRghSq_8M2vU5oxLn8jR1zppjNDyGwi"; // ⚡ replace with your key or load from env
    $url = "https://api.resend.com/emails";

    $payload = [
        "from" => "meet@proforms.top",   // must be a verified sender domain in Resend
        "to" => [$email],
        "subject" => "You're Invited to Join a Call 🎥",
        "html" => "
            <h2>You have been invited to join a call</h2>
            <p>Click below to join:</p>
            <p><a href='$callLink' target='_blank'>$callLink</a></p>
            <br>
            <p>Best regards,<br>Your App Team</p>
        "
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $apiKey",
        "Content-Type: application/json"
    ]);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode >= 200 && $httpCode < 300) {
        echo json_encode(['success' => true, 'message' => 'Invite sent via Resend']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Resend API error', 'response' => $response]);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Server error']);
}