<?php

require __DIR__ . '/../vendor/autoload.php';
require 'settings.php';
session_start();

// You must have a logged-in user and a stable user id in session
if (!isset($_SESSION['user_id'])) {
    http_response_code(403);
    echo 'Not authorized';
    exit;
}



$pusher = new Pusher\Pusher(
    $app_key,
    $app_secret,
    $app_id,
    ['cluster' => $app_cluster, 'useTLS' => true]
);

// Pusher client sends `socket_id` and `channel_name` in POST body
$socket_id = $_POST['socket_id'] ?? null;
$channel_name = $_POST['channel_name'] ?? null;

if (!$socket_id || !$channel_name) {
    http_response_code(400);
    echo 'Bad request';
    exit;
}

// Use your session user id and some user info to identify presence member
$user_id = (string) $_SESSION['user_id'];
$user_info = [
    'name' => $_SESSION['user_name'] ?? 'user-'.$user_id
];

// For presence channels use presence_auth
$auth = $pusher->presence_auth($channel_name, $socket_id, $user_id, $user_info);

// Return JSON auth string (Pusher expects this)
header('Content-Type: application/json');
echo $auth;