<?php
// server/send-signal.php
require __DIR__ . '/../vendor/autoload.php';
session_start();

// Replace with your actual Pusher credentials
$app_id = 'PUSHER_APP_ID';
$app_key = 'PUSHER_APP_KEY';
$app_secret = 'PUSHER_APP_SECRET';
$app_cluster = 'PUSHER_APP_CLUSTER';

$pusher = new Pusher\Pusher(
    $app_key,
    $app_secret,
    $app_id,
    [
        'cluster' => $app_cluster,
        'useTLS' => true
    ]
);

// read body
$body = json_decode(file_get_contents('php://input'), true);
if (!$body || !isset($body['roomId'], $body['event'], $body['payload'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Invalid payload']);
    exit;
}

$roomId = $body['roomId'];
$event = $body['event'];
$payload = $body['payload'];

// optionally verify session user is allowed to send to this room. Example:
// if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] !== $payload['user_id']) { ... }

$channel = "presence-call-{$roomId}";

// trigger event (will be received by all members subscribed)
try {
    $pusher->trigger($channel, $event, $payload);
    echo json_encode(['success' => true]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}