<?php
$appID = 1363004351; 
$appSign = "f6f1940f61be55f28350bc17b23a7113b6295474c8179c21a3b280e01cb7aa84"; 
$roomID = isset($_GET['room']) ? $_GET['room'] : "room1";
$userID = rand(1000, 9999);
$userName = "User_" . $userID;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Zego Meeting</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/@zegocloud/zego-uikit-prebuilt"></script>
</head>
<body class="bg-gray-900 text-white h-screen flex flex-col">
    <header class="p-4 bg-gray-800 flex justify-between items-center">
        <h1 class="text-lg font-bold">📞 Zego Meeting</h1>
        <span class="text-sm opacity-75">Room: <?= htmlspecialchars($roomID) ?></span>
    </header>

    <main id="root" class="flex-1"></main>

    <script>
        const appID = <?= $appID ?>;
        const appSign = "<?= $appSign ?>";
        const roomID = "<?= $roomID ?>";
        const userID = "<?= $userID ?>";
        const userName = "<?= $userName ?>";

        // This is correct for AppSign usage
        const token = ZegoUIKitPrebuilt.generateKitTokenForTest(appID, appSign, roomID, userID, userName);

        const zp = ZegoUIKitPrebuilt.create(token);
        zp.joinRoom({
            container: document.querySelector("#root"),
            sharedLinks: [
                {
                    name: 'Join Link',
                    url: `${window.location.origin}${window.location.pathname}?room=${roomID}`
                }
            ],
            scenario: {
                mode: ZegoUIKitPrebuilt.VideoConference
            }
        });
    </script>
</body>
</html>