<?php
session_start();
require_once '../db/db_connect.php'; // adjust path

header('Content-Type: application/json');

// Ensure login
if (!isset($_SESSION['user_id'])) {
    echo json_encode([
        'success' => false,
        'message' => 'Not logged in'
    ]);
    exit();
}

$user_id = $_SESSION['user_id'];
$room_id = $_GET['room'] ?? null;

if (!$room_id) {
    echo json_encode([
        'success' => false,
        'message' => 'No room specified'
    ]);
    exit();
}

// Fetch the call
$stmt = $pdo->prepare("SELECT attenders_id FROM calls WHERE room_id = :room_id LIMIT 1");
$stmt->execute(['room_id' => $room_id]);
$call = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$call) {
    echo json_encode([
        'success' => false,
        'message' => 'Room not found'
    ]);
    exit();
}

// Parse existing attenders into array
$attenders = [];
if (!empty($call['attenders_id'])) {
    $attenders = explode(',', $call['attenders_id']);
    $attenders = array_map('trim', $attenders);
}

// Add user if not already there
if (!in_array($user_id, $attenders)) {
    $attenders[] = $user_id;
}

// Save back as string
$new_attenders = implode(',', $attenders);

$update = $pdo->prepare("UPDATE calls SET attenders_id = :attenders WHERE room_id = :room_id");
$update->execute([
    'attenders' => $new_attenders,
    'room_id' => $room_id
]);

echo json_encode([
    'success' => true,
    'message' => 'Attendance updated',
    'room_id' => $room_id,
    'attenders' => $attenders
]);