<?php
session_start();
require_once '../db/db_connect.php';
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit;
}

try {
    $user_id = $_SESSION['user_id'];
    $limit = 5; // maximum rooms per user

    // Check how many rooms this user has already created
    $stmt = $conn->prepare('SELECT COUNT(*) as total FROM calls WHERE user_id = ?');
    $stmt->bind_param('i', $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $currentCount = $row['total'];
    $stmt->close();

    if ($currentCount >= $limit) {
        http_response_code(403);
        echo json_encode(['success' => false, 'message' => "Room creation limit of $limit reached"]);
        exit;
    }
$room_id = strtolower(bin2hex(random_bytes(8)));


    // Create new room
    $stmt = $conn->prepare('INSERT INTO calls (room_id, user_id, created_at) VALUES (?, ?, NOW())');
    $stmt->bind_param('si', $room_id, $user_id);
    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'room_id' => $room_id]);
    } else {
        throw new Exception('Failed to create call');
    }
    $stmt->close();

} catch (Exception $e) {
    error_log('Error in start_call.php: ' . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Server error']);
} finally {
    $conn->close();
}
?>