<?php
session_start();
require_once '../../server/db/db_connect.php'; // adjust path if needed

session_start();

if (!isset($_SESSION['user_id'])) {
    // Store the current page with query string (e.g. call.php?room=xxxx)
    $_SESSION['redirect_after_login'] = $_SERVER['REQUEST_URI'];

    // Redirect to login with a warning
    header("Location: ../login.php?warning=Login to continue to your Call");
    exit();
}

// 2. Check if room is provided in query
if (!isset($_GET['room']) || empty($_GET['room'])) {
    header("Location: ./?error=No room specified");
    exit();
}

$room_id = $_GET['room'];

// 3. Validate if the call room exists in DB
$stmt = $pdo->prepare("SELECT * FROM calls WHERE room_id = :room_id LIMIT 1");
$stmt->execute(['room_id' => $room_id]);
$call = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$call) {
    header("Location: ./?error=Invalid or expired room");
    exit();
}

/*
if ($call['host_id'] !== $_SESSION['user_id']) {
    header("Location: ../dashboard.php?error=You are not authorized to join this room");
    exit();
}
*/
?>
<!DOCTYPE html>
<html lang="en" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Meet Video Call</title>
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: { brand: '#FDC500' }
                }
            }
        }
    </script>
    <style>
        #root { width: 100%; height: 80vh; position: relative; }
        .avatar-overlay { 
            width: 3rem; height: 3rem; border-radius: 9999px; 
            border: 2px solid white; 
            position: absolute; z-index: 50; display: flex; align-items: center; justify-content: center; 
            overflow: hidden; background-color: gray; 
        }
        .participant-avatar { width: 100%; height: 100%; object-fit: cover; }
    </style>
</head>

<body class="bg-gray-100 dark:bg-gray-900 text-gray-900 dark:text-gray-100">
  <?php include 'nav.php' ?>
    <main class="max-w-7xl mx-auto px-4 py-6">

        <!-- Call Container -->
        <div class="rounded-xl overflow-hidden shadow-xl border border-gray-300 dark:border-gray-700 relative">
            <div id="root"></div>
            <!-- User Avatar Top-right -->
            <img id="user-avatar" class="w-12 h-12 rounded-full shadow-lg border-2 border-white dark:border-gray-800 fixed top-4 hidden md:hidden right-4 z-50" src="" alt="User Avatar">
        </div>
    </main>
<script>
document.addEventListener("DOMContentLoaded", function() {
    const room = new URLSearchParams(window.location.search).get("room");

    fetch(`../../server/call/call_join.php?room=${room}`)
        .then(res => res.json())
        .then(data => {
            if (!data.success) {
                window.location.href = data.redirect;
            } else {
                console.log("Joined call room:", data.room_id);
                // continue loading call UI...
            }
        })
        .catch(err => {
            // console.error("Error:", err);
            
        });
});
</script>
    <script src="https://unpkg.com/@zegocloud/zego-uikit-prebuilt/zego-uikit-prebuilt.js"></script>
    <script>
        window.onload = function () {
            let userFullName = "Guest";
            let userAvatar = "https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQLRR01baAbZWD7vRECh-dBVs4mwu6tOeVwIW7Nz39zmHBDcjz2cOhDcA&s";
            let userID = Math.floor(Math.random() * 10000) + "";
            let roomID;
            let callStartTime = null;
            let timerInterval = null;

            // Fetch authenticated user info
            fetch('../../server/auth/check_session.php', {
                method: 'GET',
                headers: { 'Content-Type': 'application/json' }
            })
            .then(res => res.json())
            .then(data => {
                if (!data.success) {
                    window.location.href = '../login.php?warning=Login to continue to your Call';
                    return;
                }

                userFullName = data.user.full_name || data.user.username || "User";
                document.getElementById('username-display').textContent = data.user.username;
                userAvatar = data.user.avatar || 'https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQLRR01baAbZWD7vRECh-dBVs4mwu6tOeVwIW7Nz39zmHBDcjz2cOhDcA&s';
                document.getElementById('user-avatar').src = userAvatar;

                startZegoCall(userFullName, userAvatar, userID);
            })
            .catch(err => console.error(err));

            function startZegoCall(fullName, avatarUrl, userID) {
                const params = Object.fromEntries(new URLSearchParams(window.location.search));
                roomID = params['room'] || (Math.floor(Math.random() * 10000) + "");

                const appID = 1363004351;
                const serverSecret = "0d27fd2dffae244e2ae85629f0f23ef8";

                const kitToken = ZegoUIKitPrebuilt.generateKitTokenForTest(appID, serverSecret, roomID, userID, fullName);
                const zp = ZegoUIKitPrebuilt.create(kitToken);

                // Prepare UI containers
                const participantCountEl = document.createElement('div');
                participantCountEl.id = 'participant-count';
                participantCountEl.className = 'fixed top-4 right-4 bg-black/50 text-white px-3 py-1 rounded-lg font-mono z-50';
                document.body.appendChild(participantCountEl);

                const participantAvatarsEl = document.createElement('div');
                participantAvatarsEl.id = 'participant-avatars';
                participantAvatarsEl.className = 'fixed top-12 right-4 flex space-x-1 z-50';
                document.body.appendChild(participantAvatarsEl);

                const timerEl = document.getElementById('call-timer'); // Use existing timer element

                zp.joinRoom({
                    container: document.querySelector("#root"),
                    scenario: { mode: ZegoUIKitPrebuilt.VideoConference },
                    // Prejoin view settings
                    showPreJoinView: false, // Keep as false per your example
                    preJoinViewConfig: {
                        title: "Join Video Call" // Custom title for prejoin view (if enabled later)
                    },
                    turnOnMicrophoneWhenJoining: true,
                    turnOnCameraWhenJoining: true,
                    useFrontFacingCamera: true, // Use front-facing camera by default
                    videoResolutionDefault: "360p", // Set default video resolution
                    // Room view settings
                    showMyCameraToggleButton: true,
                    showMyMicrophoneToggleButton: true,
                    showAudioVideoSettingsButton: true,
                    showScreenSharingButton: true,
                    showTextChat: true,
                    showUserList: true,
                    maxUsers: 10,
                    layout: "Auto",
                    showLayoutButton: true, // Allow layout switching
                    showNonVideoUser: true, // Show non-video participants
                    showOnlyAudioUser: true, // Show audio-only participants
                    showTurnOffRemoteCameraButton: true, // Allow muting remote cameras
                    showTurnOffRemoteMicrophoneButton: true, // Allow muting remote microphones
                    showRoomDetailsButton: true, // Show room details
                    showRoomTimer: true, // Show ZEGOCLOUD's built-in timer
                    lowerLeftNotification: {
                        showUserJoinAndLeave: true, // Show join/leave notifications
                        showTextChat: true // Show latest chat messages
                    },
                    branding: {
                        logoURL: "/assets/images/logo-light.png"
                    },
                    screenSharingConfig: {
                        resolution: "1080p", // High-quality screen sharing
                        frameRate: 15,
                        maxBitRate: 2000 // 2Mbps for smooth sharing
                    },
                    whiteboardConfig: {
                        showAddImageButton: false, // Requires File Sharing plugin
                        showCreateAndCloseButton: true // Enable whiteboard creation
                    },
                    enableUserSearch: true, // Enable user search in participant list
                    showMoreButton: true, // Show "More" options button
                    showUserName: true, // Display usernames in chat
                    // Leaving view settings
                    showLeavingView: true,
                    showLeaveRoomConfirmDialog: true, // Confirm before leaving
                    // Event callbacks
                    onJoinRoom: () => {
                        console.log("Joined the room:", roomID);
                    },
onLeaveRoom: () => {
    console.log("Left the room:", roomID);
    clearInterval(timerInterval);

    // Calculate call duration
    const callEndTime = Date.now();
    const duration = Math.floor((callEndTime - callStartTime) / 1000); // in seconds

    // Send usage data via AJAX to end_call.php
    fetch('../../server/call/end_call.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({
            room_id: roomID,
            duration: duration,
            user_id: userID
        })
    })
    .then(res => res.json())
    .then(data => {
        console.log("Call data updated:", data);
    })
.catch(async (err) => {
//
});
},


                    onUserJoin: (users) => {
                        console.log("Users joined:", users);
                        updateParticipants(users);
                    },
                    onUserLeave: (users) => {
                        console.log("Users left:", users);
                        updateParticipants(users);
                    },
                    onInRoomMessageReceived: (messageInfo) => {
                        console.log("New message:", messageInfo);
                    }
                }).then(() => {
                    // Initialize call start time for custom timer
                    callStartTime = Date.now();
                    timerInterval = setInterval(updateTimer, 1000);
                });

                // Update live participant info
                function updateParticipants(users) {
                    // Participant count
                    participantCountEl.textContent = `${users.length} in call`;

                    // Avatars
                    participantAvatarsEl.innerHTML = '';
                    users.forEach(u => {
                        const img = document.createElement('img');
                        img.src = u.avatar || 'https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQLRR01baAbZWD7vRECh-dBVs4mwu6tOeVwIW7Nz39zmHBDcjz2cOhDcA&s';
                        img.className = 'w-8 h-8 rounded-full border-2 border-white';
                        participantAvatarsEl.appendChild(img);
                    });

                    // Duplicate username detection
                    const names = users.map(u => u.userName);
                    const duplicates = names.filter((name, i) => names.indexOf(name) !== i);
                    if (duplicates.length > 0) {
                        alert('Duplicate username detected! Ending call.');
                        endCall();
                    }
                }

                // Fallback avatars if camera off
                zp.on('user-video-state-update', (userList) => {
                    updateParticipants(userList);

                    userList.forEach(user => {
                        const el = document.querySelector(`#root [data-zego-user-id="${user.userID}"] video`);
                        if (el && !user.video) {
                            let avatarEl = el.parentElement.querySelector('.avatar-overlay');
                            if (!avatarEl) {
                                avatarEl = document.createElement('div');
                                avatarEl.className = 'avatar-overlay absolute inset-0 flex justify-center items-center bg-gray-800';
                                const img = document.createElement('img');
                                img.className = 'participant-avatar w-16 h-16 rounded-full';
                                img.src = user.avatar || 'default-avatar.png';
                                avatarEl.appendChild(img);
                                el.parentElement.appendChild(avatarEl);
                            }
                            el.style.display = 'none';
                        } else if (el && user.video) {
                            const avatarEl = el.parentElement.querySelector('.avatar-overlay');
                            if (avatarEl) avatarEl.remove();
                            el.style.display = 'block';
                        }
                    });
                });

                // Show invite info
                const inviteBox = document.getElementById('inviteInfo'); // Use existing inviteInfo
                inviteBox.innerHTML = `
                    Room ID: <b>${roomID}</b> <br>
                    Name: <b>${fullName}</b> <br>
                    Share this link: <br>
                    <span style="color:#FDC500;">${window.location.protocol + '//' + window.location.host + window.location.pathname + '?room=' + roomID}</span>
                `;
            }

            // Custom timer update
            function updateTimer() {
                if (callStartTime) {
                    const elapsed = Math.floor((Date.now() - callStartTime) / 1000);
                    const minutes = Math.floor(elapsed / 60).toString().padStart(2, '0');
                    const seconds = (elapsed % 60).toString().padStart(2, '0');
                    document.getElementById('call-timer').textContent = `${minutes}:${seconds}`;
                }
            }

// Update your endCall function to trigger ZEGOCLOUD leave event
function endCall() {
    clearInterval(timerInterval);
    zp.leaveRoom(); // This will trigger onLeaveRoom and send AJAX
    window.location.href = '/'; // Redirect after call ends
}
        }

        // Warn on refresh
        window.addEventListener('beforeunload', function (e) {
            e.preventDefault();
            e.returnValue = 'Your call progress will be lost if you leave!';
        });
    </script>
    <script>
          // Theme Toggle
    const themeToggle = document.getElementById('theme-toggle');
    const sunIcon = document.getElementById('sun-icon');
    const moonIcon = document.getElementById('moon-icon');

    function toggleTheme() {
      const isDark = document.documentElement.classList.toggle('dark');
      localStorage.setItem('theme', isDark ? 'dark' : 'light');
      sunIcon.classList.toggle('hidden', isDark);
      moonIcon.classList.toggle('hidden', !isDark);
    }

    themeToggle.addEventListener('click', toggleTheme);

    if (localStorage.getItem('theme') === 'dark' || (!localStorage.getItem('theme') && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
      document.documentElement.classList.add('dark');
      sunIcon.classList.add('hidden');
      moonIcon.classList.remove('hidden');
    } else {
      document.documentElement.classList.remove('dark');
      sunIcon.classList.remove('hidden');
      moonIcon.classList.add('hidden');
    }
  
  const avatarBtn = document.getElementById('avatar-btn');
  const userMenu = document.getElementById('user-menu');

  avatarBtn.addEventListener('click', () => {
    const isHidden = userMenu.classList.contains('hidden');
    userMenu.classList.toggle('hidden', !isHidden);
    userMenu.classList.toggle('scale-95', !isHidden);
    userMenu.classList.toggle('opacity-0', !isHidden);
    userMenu.classList.toggle('scale-100', isHidden);
    userMenu.classList.toggle('opacity-100', isHidden);
  });

  // Close dropdown when clicking outside
  document.addEventListener('click', (e) => {
    if (!avatarBtn.contains(e.target) && !userMenu.contains(e.target)) {
      userMenu.classList.add('hidden', 'scale-95', 'opacity-0');
      userMenu.classList.remove('scale-100', 'opacity-100');
    }
  });
</script>
</body>
</html>