<!-- Header -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<header class="bg-white/90 dark:bg-gray-900/90 backdrop-blur-xl shadow-lg sticky top-0 z-20">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4">
    <div class="flex items-center justify-between">
      <!-- Logo Section -->
      <div class="flex items-center space-x-3">
        <svg class="w-8 h-8 text-black dark:text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" d="M3 8v8a3 3 0 003 3h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3zm9 4a2 2 0 110-4 2 2 0 010 4z" />
        </svg>
        <a href="./" class="text-2xl font-extrabold tracking-tight text-black dark:text-white">Meet</a>
      </div>
        <button id="theme-toggle" class="p-2 rounded-full bg-gray-100 dark:bg-gray-800 text-black dark:text-white hover:bg-gray-200 dark:hover:bg-gray-700 transition">
          <svg id="sun-icon" class="w-5 h-5 block dark:hidden" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M12 3v2.25m0 13.5V21m8.25-9h-2.25m-13.5 0H3m15.364-6.364l-1.591 1.591M6.227 6.227l1.591 1.591m0 10.818l-1.591 1.591M18.364 18.364l1.591-1.591M12 8.25a3.75 3.75 0 100 7.5 3.75 3.75 0 000-7.5z" />
          </svg>
          <svg id="moon-icon" class="w-5 h-5 hidden dark:block" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z" />
          </svg>
        </button>
      <!-- User Section -->
      <div class="relative">
        
        <button id="avatar-btn" class="flex items-center focus:outline-none">
          <img id="avatar-display" src="https://picsum.photos/200/300" alt="User avatar" class="w-10 h-10 rounded-full object-cover">
        </button>
        <!-- Dropdown Menu -->
        <div id="user-menu" class="hidden absolute right-0 mt-2 w-48 bg-white dark:bg-gray-800 rounded-lg shadow-lg py-2 z-30 transform origin-top-right transition-all duration-300 scale-95 opacity-0">
          <div class="px-4 py-2 text-black dark:text-white font-medium border-b border-gray-200 dark:border-gray-700">
            <span id="username-display"></span>
          </div>
          <button id="logout-btn" class="w-full text-left px-4 py-2 bg-red-500 text-white font-medium hover:bg-red-600 transition-all duration-300">
            Log Out
          </button>
        </div>
      </div>
    </div>
  </div>
</header>
