  <script>


    // Start Call
    document.getElementById('start-call-btn').addEventListener('click', async () => {
  try {
    document.getElementById('start-call-btn').innerHTML = "Creating...";
    const response = await fetch('../../server/call/start_call.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({
        action: 'start_call' // or include user_id/session info if needed
      })
    });
document.getElementById('start-call-btn').innerHTML = "Get New Call Link";
    const data = await response.json();

    if (data.success) {
      const roomId = data.room_id;
      const callLink = `${window.location.origin}/call.php?room=${roomId}`;

      Swal.fire({
        title: '🎉 Call Room Created!',
        html: `
          <p class="mb-3 text-gray-700 dark:text-gray-300">Share this link to invite others:</p>
          <input type="text" readonly value="${callLink}" 
                 class="swal2-input text-center" 
                 style="width:100%;cursor:pointer"
                 onclick="this.select()">

          <div class="mt-4 flex flex-wrap gap-3 justify-center">  
            <a href="https://wa.me/?text=Join%20my%20call:%20${encodeURIComponent(callLink)}" target="_blank" class="px-3 py-2 bg-green-500 hover:bg-green-600 text-white rounded-lg">WhatsApp</a>  
            <a href="https://twitter.com/intent/tweet?url=${encodeURIComponent(callLink)}&text=Join%20my%20call!" target="_blank" class="px-3 py-2 bg-blue-500 hover:bg-blue-600 text-white rounded-lg">Twitter</a>  
            <a href="https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(callLink)}" target="_blank" class="px-3 py-2 bg-blue-700 hover:bg-blue-800 text-white rounded-lg">Facebook</a>  
            <a href="https://t.me/share/url?url=${encodeURIComponent(callLink)}&text=Join%20my%20call!" target="_blank" class="px-3 py-2 bg-sky-500 hover:bg-sky-600 text-white rounded-lg">Telegram</a>  
            <a href="https://www.linkedin.com/sharing/share-offsite/?url=${encodeURIComponent(callLink)}" target="_blank" class="px-3 py-2 bg-indigo-600 hover:bg-indigo-700 text-white rounded-lg">LinkedIn</a>  
          </div>  

          <div class="mt-6">  
            <p class="text-gray-700 dark:text-gray-300 mb-2">📧 Invite by Email:</p>  
            <input type="email" id="inviteEmail" placeholder="Enter email" 
                   class="swal2-input" style="width:100%">  
          </div>  
        `,
        showCancelButton: true,
        confirmButtonText: 'Send Email Invite',
        cancelButtonText: 'Close',
        focusConfirm: false,
        preConfirm: () => {
          const email = document.getElementById('inviteEmail').value;
          if (email) {
            // 🔗 here you can post email + callLink to a backend PHP script
            return fetch('../../server/call/send_invite.php', {
              method: 'POST',
              headers: { 'Content-Type': 'application/json' },
              body: JSON.stringify({ email, callLink })
            }).then(r => r.json()).then(res => {
              if (!res.success) {
                throw new Error(res.message || "Failed to send invite");
              }
              return res;
            }).catch(err => {
              Swal.showValidationMessage(err.message);
            });
          } else {
            Swal.showValidationMessage("Please enter a valid email.");
          }
        }
      }).then(result => {
        if (result.isConfirmed) {
          Swal.fire("✅ Invite Sent!", `An invite was sent to <b>${result.value.email}</b>`, "success");
        }
      });

    } else {
      document.getElementById('call-error').textContent = data.message;
      document.getElementById('call-error').classList.remove('hidden');
    }

  } catch (error) {
    console.error(error);
    document.getElementById('call-error').textContent = 'Failed to start call. Please try again.';
    document.getElementById('call-error').classList.remove('hidden');
  }
});
    // Join Call
    document.getElementById('join-call-btn').addEventListener('click', async () => {
      
      const roomId = document.getElementById('room-id').value.trim();
      if (!roomId) {
        document.getElementById('call-error').textContent = 'Room ID is required';
        document.getElementById('call-error').classList.remove('hidden');
        return;
      }
      try {
        document.getElementById('join-call-btn').innerHTML = "Submitting..";
        const response = await fetch('../../server/call/join_call.php', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify({ room_id: roomId })
        });
        
        const data = await response.json();
        if (data.success) {
          document.getElementById('join-call-btn').innerHTML = "Joining...";
          window.location.href = `call.php?room=${roomId}`;
        } else {
          document.getElementById('join-call-btn').innerHTML = "Join";
          document.getElementById('call-error').textContent = data.message;
          document.getElementById('call-error').classList.remove('hidden');
        }
      } catch (error) {
        document.getElementById('call-error').textContent = 'Failed to join call. Please try again.';
        document.getElementById('call-error').classList.remove('hidden');
      }
    });

    // Load Call History
    fetch('../../server/call/call_history.php?limit=5', {
      method: 'GET',
      headers: { 'Content-Type': 'application/json' }
    })
      .then(response => response.json())
      .then(data => {
        if (data.success) {
          const historyDiv = document.getElementById('call-history');
          if (data.calls.length === 0) {
            historyDiv.innerHTML = '<p class="text-gray-600 dark:text-gray-400">No call history available.</p>';
          } else {
            data.calls.forEach(call => {
              historyDiv.innerHTML += `
<div class="p-6 bg-white dark:bg-gray-900 rounded-xl shadow-sm dark:shadow-gray-700/50 hover:shadow-md transition-shadow duration-200">
  <div class="space-y-3">
    <p class="text-gray-900 dark:text-gray-100">
      <span class="font-semibold">Room ID:</span> ${call.room_id}
    </p>
    <p class="text-gray-700 dark:text-gray-300">
      <span class="font-semibold">Date:</span> ${new Date(call.created_at).toLocaleString()}
    </p>
  </div>
</div>

              `;
            });
          }
        }
      })
      .catch(error => console.error('Error loading call history:', error));
    // Load Call History
    fetch('../../server/call/call_history.php', {
      method: 'GET',
      headers: { 'Content-Type': 'application/json' }
    })
      .then(response => response.json())
      .then(data => {
        if (data.success) {
          const historycall = document.getElementById('history');
          if (data.calls.length === 0) {
            historycall.innerHTML = '<p class="text-gray-600 dark:text-gray-400">No call history available.</p>';
          } else {
            data.calls.forEach(call => {
              historyDiv.innerHTML += `
<div class="p-6 bg-white dark:bg-gray-900 rounded-xl shadow-sm dark:shadow-gray-700/50 hover:shadow-md transition-shadow duration-200">
  <div class="space-y-3">
    <p class="text-gray-900 dark:text-gray-100">
      <span class="font-semibold">Room ID:</span> ${call.room_id}
    </p>
    <p class="text-gray-700 dark:text-gray-300">
      <span class="font-semibold">Date:</span> ${new Date(call.created_at).toLocaleString()}
    </p>
  </div>
</div>

              `;
            });
          }
        }
      })
      .catch(error => console.error('Error loading call history:', error));

    // Logout
    document.getElementById('logout-btn').addEventListener('click', async () => {
      await fetch('../../server/auth/logout.php', { method: 'POST' });
      window.location.href = '../login.php';
    });

    // Theme Toggle
    const themeToggle = document.getElementById('theme-toggle');
    const sunIcon = document.getElementById('sun-icon');
    const moonIcon = document.getElementById('moon-icon');

    function toggleTheme() {
      const isDark = document.documentElement.classList.toggle('dark');
      localStorage.setItem('theme', isDark ? 'dark' : 'light');
      sunIcon.classList.toggle('hidden', isDark);
      moonIcon.classList.toggle('hidden', !isDark);
    }

    themeToggle.addEventListener('click', toggleTheme);

    if (localStorage.getItem('theme') === 'dark' || (!localStorage.getItem('theme') && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
      document.documentElement.classList.add('dark');
      sunIcon.classList.add('hidden');
      moonIcon.classList.remove('hidden');
    } else {
      document.documentElement.classList.remove('dark');
      sunIcon.classList.remove('hidden');
      moonIcon.classList.add('hidden');
    }
  </script>