<?php
session_start();
require_once '../db/db_connect.php';
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit;
}
try {
    session_start();
    $user_id = $_SESSION['user_id'];

    // get page & limit safely
    $limit = isset($_GET['limit']) && is_numeric($_GET['limit']) ? (int)$_GET['limit'] : 5;
    $page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
    $offset = ($page - 1) * $limit;

    // get total count for pagination
    $countStmt = $conn->prepare("
        SELECT COUNT(*) AS total
        FROM calls
        WHERE user_id = ? OR FIND_IN_SET(?, attenders_id)
    ");
    $countStmt->bind_param("ii", $user_id, $user_id);
    $countStmt->execute();
    $countResult = $countStmt->get_result()->fetch_assoc();
    $total = $countResult['total'];
    $countStmt->close();

    // main query with pagination
    $stmt = $conn->prepare("
        SELECT room_id, created_at, duration
        FROM calls
        WHERE user_id = ? OR FIND_IN_SET(?, attenders_id)
        ORDER BY created_at DESC
        LIMIT ? OFFSET ?
    ");
    $stmt->bind_param("iiii", $user_id, $user_id, $limit, $offset);
    $stmt->execute();
    $result = $stmt->get_result();

    $calls = [];
    while ($row = $result->fetch_assoc()) {
        $calls[] = $row;
    }
    $stmt->close();

    echo json_encode([
        'success' => true,
        'calls' => $calls,
        'pagination' => [
            'total' => $total,
            'page' => $page,
            'limit' => $limit,
            'pages' => ceil($total / $limit)
        ]
    ]);
} catch (Exception $e) {
    error_log('Error in call_history.php: ' . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Server error']);
} finally {
    $conn->close();
}