<?php
session_start();
header('Content-Type: application/json');

// Enable full error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// DB connection directly here
$DB_HOST = "0.0.0.0";
$DB_USER = "root";
$DB_PASS = "root"; // change to your password
$DB_NAME = "meet_new"; // change to your database

$conn = new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);

// Check connection
if ($conn->connect_error) {
    send_json(false, "DB Connection failed: " . $conn->connect_error);
}

// Helper: send JSON and exit
function send_json($success, $message, $extra = []) {
    http_response_code($success ? 200 : 400);
    echo json_encode(array_merge([
        'success' => $success,
        'message' => $message
    ], $extra), JSON_UNESCAPED_UNICODE);
    exit;
}

// Read raw input
$rawData = file_get_contents("php://input");
$data = json_decode($rawData, true);

// Validate JSON body
if (json_last_error() !== JSON_ERROR_NONE) {
    send_json(false, 'Invalid JSON: ' . json_last_error_msg(), ['raw' => $rawData]);
}

// Check required fields
if (!$data || !isset($data['room_id'], $data['duration'], $data['user_id'])) {
    send_json(false, 'Missing required fields', ['received' => $data]);
}

$roomId   = $conn->real_escape_string($data['room_id']);
$userId   = intval($data['user_id']);
$duration = intval($data['duration']);

// Find existing call
$sql = "SELECT * FROM calls 
        WHERE room_id = '$roomId' AND user_id = $userId 
        ORDER BY created_at DESC 
        LIMIT 1";
$result = $conn->query($sql);

if (!$result) {
    send_json(false, 'DB Error: ' . $conn->error, ['query' => $sql]);
}

if ($result->num_rows > 0) {
    // Update existing
    $update = "UPDATE calls 
               SET duration = $duration, 
                   usage_log = JSON_OBJECT('ended_at', NOW(), 'duration_seconds', $duration) 
               WHERE room_id = '$roomId' AND user_id = $userId";
    if ($conn->query($update)) {
        send_json(true, 'Call updated', ['query' => $update]);
    } else {
        send_json(false, 'DB Update Error: ' . $conn->error, ['query' => $update]);
    }
} else {
    // Insert new
    $insert = "INSERT INTO calls (room_id, user_id, created_at, duration, usage_log) 
               VALUES ('$roomId', $userId, NOW(), $duration, JSON_OBJECT('ended_at', NOW(), 'duration_seconds', $duration))";
    if ($conn->query($insert)) {
        send_json(true, 'Call inserted', ['query' => $insert]);
    } else {
        send_json(false, 'DB Insert Error: ' . $conn->error, ['query' => $insert]);
    }
}