<?php
require __DIR__ . '/../../vendor/autoload.php';
error_reporting(0);

$dotenv = Dotenv\Dotenv::createImmutable(__DIR__ . '/../../');
$dotenv->load();

$host   = $_ENV['DB_HOST'];
$user   = $_ENV['DB_USER'];
$pass   = $_ENV['DB_PASS'];
$dbname = $_ENV['DB_NAME'];

/**
 * MYSQLi Connection ($conn)
 */
$conn = new mysqli($host, $user, $pass);

// Check connection
if ($conn->connect_error) {
    die("Connection failed (MySQLi): " . $conn->connect_error);
}

// Ensure DB exists
$conn->query("CREATE DATABASE IF NOT EXISTS `$dbname`");
$conn->select_db($dbname);

/**
 * PDO Connection ($pdo)
 */
try {
    $dsn = "mysql:host=$host;dbname=$dbname;charset=utf8mb4";
    $pdo = new PDO($dsn, $user, $pass, [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ]);
} catch (PDOException $e) {
    die("Connection failed (PDO): " . $e->getMessage());
}